document.addEventListener('DOMContentLoaded', function() {
    const settingsForm = document.querySelector('.settings-container form');
    
    settingsForm.addEventListener('submit', async function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        
        try {
            const response = await fetch(this.action, {
                method: 'POST',
                body: formData
            });
            
            if (response.ok) {
                showNotification('Settings updated successfully!', 'success');
                // Reload the page to show updated settings
                setTimeout(() => {
                    window.location.reload();
                }, 1500);
            } else {
                const data = await response.json();
                showNotification('Error updating settings: ' + data.error, 'error');
            }
        } catch (error) {
            console.error('Error:', error);
            showNotification('Error updating settings. Please try again.', 'error');
        }
    });
});

function showNotification(message, type) {
    const notification = document.createElement('div');
    notification.className = `alert alert-${type === 'success' ? 'success' : 'danger'} alert-dismissible fade show`;
    notification.style.position = 'fixed';
    notification.style.top = '20px';
    notification.style.right = '20px';
    notification.style.zIndex = '1000';
    
    notification.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    `;
    
    document.body.appendChild(notification);
    
    // Auto remove after 3 seconds
    setTimeout(() => {
        notification.remove();
    }, 3000);
} 